---
type: meta
tags:
  - "#layer/translation"
  - "#status/stable"
  - "#function/observation"
---

# 00.0.0.0 - Core Axioms (index)

> Foundational statements that ground the kernel primitives and enable difference-based recursion.

---

## Module Overview

The Core Axioms module provides the irreducible foundation of Delta Theory. It defines:
- Three foundational axioms (A1-A3) that establish the minimal ontological base
- Their mapping to the SVA triad (Structure, Void, Awareness)
- The emergence of core constants (both direct and derived)
- Guidelines for domain-specific implementations

These axioms work together to enable difference-based recursion while maintaining both technical precision and humane understanding.

---

## Content Structure

| Category | Description | Key Elements |
|----------|-------------|--------------|
| Core Axioms | Foundational ontological truths | [[A1 — Irreducibility (axiom)]], [[A2 — Asymmetry (axiom)]], [[A3 — Recursivity (axiom)]] |
| SVA Mapping | Polarity and domain alignment | P0 (Awareness), P- (Void), P+ (Structure) |
| Direct Constants | Primary emergent anchors | [[ε — Difference Resolution Quantum (constant)]], [[φ — Asymmetric Stabilization Ratio (constant)]], [[e — Natural Transformation Rate (constant)]] |
| Derived Constants | Secondary emergent anchors | [[c — Difference Propagation Limit (constant)]], [[π — Closure Geometry Ratio (constant)]] |

Each axiom provides:
- Technical and humane mappings
- Polarity alignment
- Constant emergence
- Domain examples

---

## Core References

Primitives:
- [[Delta]]
- [[RelationalEmbedding]]
- [[Stabilization (Closure)]]
- [[Form]]

Anchors (Direct):
- [[ε — Difference Resolution Quantum (constant)]] ← A1
- [[φ — Asymmetric Stabilization Ratio (constant)]] ← A2
- [[e — Natural Transformation Rate (constant)]] ← A3

Anchors (Emergent):
- [[c — Difference Propagation Limit (constant)]] ← A2
- [[π — Closure Geometry Ratio (constant)]] ← A3

Related Modules:
- [[00.0.0 - Virtual Substrate — Kernel Primitives (index)]]
- [[00.0.0.1 - Anchors — Constants & Modulators (index)]]
- [[00.0.0.2 - Structural Primitives (index)]]

---

## Implementation Notes

### SVA Triad Mapping

| Axiom | Polarity | Domain | Core Role |
|-------|----------|---------|-----------|
| A1 (Irreducibility) | P0 | Awareness | Distinction itself |
| A2 (Asymmetry) | P- | Void | Field directionality |
| A3 (Recursivity) | P+ | Structure | Form-making |

### Domain Manifestations

| Domain | Structure (A3) | Void (A2) | Awareness (A1) |
|--------|---------------|------------|----------------|
| Physics | Wave patterns | Field propagation | Quantum measurement |
| Chemistry | Molecular structure | Reaction paths | Bonding states |
| Biology | Growth forms | Environmental flow | Sensory distinction |
| Social | Community patterns | Influence paths | Identity recognition |
| Economy | Market structure | Value flows | Price discovery |
| Politics | Institutions | Power dynamics | Cultural awareness |
| Networks | Graph topology | Message routing | State coherence |
| Cognition | Memory patterns | Attention flow | Conscious distinction |

### Technical Implementation

| Axiom | Network Construct | Interface Example |
|-------|------------------|-------------------|
| A1 | Atomic event | `PrimitiveEvent` |
| A2 | Directed edge | `DirectedLink` |
| A3 | Nested closure | `RecursiveWrapper` |

### Special Considerations

1. **Ontological Independence**
   - Each axiom covers a distinct aspect
   - No circular dependencies
   - Clear emergence patterns

2. **Dual-Register Grounding**
   - Technical precision without reduction
   - Humane understanding without loss
   - Clear bridging principles

3. **Constant Emergence**
   - Direct constants from single axioms
   - Emergent constants from interactions
   - Clear derivation paths

4. **Domain Flexibility**
   - Scale-aware manifestation
   - Domain-specific interpretation
   - Consistent core meaning

See [PRINCIPLES.md](../../../../../PRINCIPLES.md) for how they avoid reduction (biology ≠ networks; tech ≠ biology).

---

## See Also

- [[00.0.0 - Virtual Substrate — Kernel Primitives (index)]]
- [[A1 — Irreducibility (axiom)]]
- [[A2 — Asymmetry (axiom)]]
- [[A3 — Recursivity (axiom)]]
- [[Field]] · [[Void]] · [[Structure]] · [[Awareness]]